﻿/*
    Sunburst: Halo Reach Game Variant Rehasher

    Copyright (C) 2011 Aaron Dierking
    Copyright (C) 2012 Nuklear

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography;

namespace Sunburst.Lite
{
    /// <summary>
    /// Computes salted SHA-1 digests using Reach's key.
    /// </summary>
    public class SaltedSHA1 : SHA1Managed
    {
        private byte[] salt;

        /// <summary>
        /// Constructs and initializes a new SaltedSHA1 object.
        /// </summary>
        /// <param name="salt">The salt to use</param>
        /// <seealso cref="Initialize"/>
        public SaltedSHA1(byte[] salt)
        {
            this.salt = salt;
            Initialize();
        }

        /// <summary>
        /// Initializes the hash by transforming the salt.
        /// </summary>
        public override void Initialize()
        {
            base.Initialize();
            base.TransformBlock(this.salt, 0, this.salt.Length, this.salt, 0);
        }
    }
}